/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.InstanceComparator;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.ReservoirSample;

public class ReservoirSampleTest
extends AbstractFilterTest {
    protected InstanceComparator m_Comparator;

    public ReservoirSampleTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Comparator = new InstanceComparator(true);
    }

    @Override
    public Filter getFilter() {
        ReservoirSample r = new ReservoirSample();
        return r;
    }

    public void testTypical() {
        this.m_Filter = this.getFilter();
        Instances result = this.useFilter();
        ReservoirSampleTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        ReservoirSampleTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < this.m_Instances.numInstances()) {
            if (this.m_Comparator.compare(this.m_Instances.instance(i), result.instance(i)) != 0) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            ReservoirSampleTest.fail("Result should be equal");
        }
    }

    public void testSubSample() {
        this.m_Filter = this.getFilter();
        ((ReservoirSample)this.m_Filter).setSampleSize(10);
        Instances result = this.useFilter();
        ReservoirSampleTest.assertEquals(result.numInstances(), 10);
        boolean equal = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Comparator.compare(this.m_Instances.instance(i), result.instance(i)) != 0) {
                equal = false;
                break;
            }
            ++i;
        }
        if (equal) {
            ReservoirSampleTest.fail("Result should be different than the first 10 instances");
        }
    }

    public void testHeaderOnlyInput() {
        this.m_Filter = this.getFilter();
        this.m_Instances = new Instances(this.m_Instances, 0);
        Instances result = this.useFilter();
        ReservoirSampleTest.assertEquals(result.numInstances(), this.m_Instances.numInstances());
    }

    public static Test suite() {
        return new TestSuite(ReservoirSampleTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(ReservoirSampleTest.suite());
    }
}

